<?php
include('db.php');

// 🔐 Define your private registration key (set your own value)
define('REGISTRATION_KEY', 'DIVAKARKUMAR2001'); // <-- change this secret key!

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $provided_key = trim($_POST['reg_key']);

    // Check if registration key matches
    if ($provided_key !== REGISTRATION_KEY) {
        $error = "❌ Invalid registration key! Please contact the admin.";
    } else {
        // Proceed with registration if key is correct
        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bind_param("ss", $username, $password);

        if ($stmt->execute()) {
            header("Location: index.php");
            exit;
        } else {
            $error = "⚠️ Username already exists!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title>Register | MyApp</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container mt-5">
    <div class="col-md-4 offset-md-4">
      <div class="card shadow p-4">
        <h4 class="text-center mb-4">Register</h4>
        <?php if (!empty($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
        <form method="POST">
          <input type="text" name="username" class="form-control mb-3" placeholder="Username" required>
          <input type="password" name="password" class="form-control mb-3" placeholder="Password" required>
          <input type="text" name="reg_key" class="form-control mb-3" placeholder="Enter Registration Key" required>
          <button type="submit" class="btn btn-success w-100">Register</button>
        </form>
        <p class="text-center mt-3">Already have an account? <a href="index.php">Login</a></p>
      </div>
    </div>
  </div>
</body>
</html>
